<?php
session_start();
$user = null; // Initialize $user to null

// Check if the user is logged in
if (isset($_SESSION["user_id"])) {
    
    // Connect to the database
    $mysqli = require __DIR__ . "/database.php";
    
    // Use prepared statement to avoid SQL injection and fetch user data safely
    $sql = "SELECT * FROM user WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $_SESSION["user_id"]);
    $stmt->execute();
    $result = $stmt->get_result();
    
    // Fetch the user data
    $user = $result->fetch_assoc();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">

    <title>ArloMusic</title>
    <style>
        .header {
            min-height: 100vh;
    width: 100%;
    background-image: linear-gradient(rgba(4, 9, 30, 0.7), rgba(4, 9, 30, 0.7)), url(Images/party.jpeg);
}
            
        .HeaderLow {
            display: flex;
            overflow: hidden;
            background-color: transparent;
            width: 100%;
            height: 600px;
            white-space: nowrap;
            position: relative;
        }

        .scroll-container {
    display: flex;
    animation: scroll 50s linear infinite;
    width: max-content; /* Adjust this based on the number of .container1 elements */
    margin-top: -100px;
}


        @keyframes scroll {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }

        .container1 {
            display: inline-flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 50px;
            background-color: #0000003a;
            border-radius: 25px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border: 1px solid transparent;
            outline: none;
            border-color: #ffffff;
            box-shadow: 0 0 20px #ffffff;
            transition: all 0.3s ease;
            margin-right: 15px;
            height: 400px;
            width: 300px;
            margin-top: -70px;
        }
        
        .container1 img {
            width: 140px;
            height: 140px;
            margin-bottom: 10px;
            border-radius: 50%;
        }

        .container1:hover {
            outline: none;
            border-color: red;
            box-shadow: 0 0 20px red;
        }

        /* Mobile responsive adjustments */
        @media (max-width: 768px) {
            .HeaderLow {
                flex-direction: column;
                align-items: center;
            }

            .container1 {
                width: 80%;
                padding: 20px;
            }

            .scroll-container {
                animation: scroll 20s linear infinite;
            }
        }
        @media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
}
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
}

.hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
}

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
    }

.hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
    .HeaderLow {
                flex-direction: column;
                align-items: center;
            }

            .container1 {
                width: 80%; /* Make containers fit better on mobile */
                padding: 20px;
            }
            .scroll-container {
    display: flex;
    animation: scroll 50s linear infinite;
    width: max-content; /* Adjust this based on the number of .container1 elements */
    margin-top: 50px;
}
.container1 img {
            width: 100px;
            height: 100px;
            margin-bottom: 10px;
            border-radius: 50%;
        }
}      
    </style>
</head>
<body>
    <section class="header" id="NavSection">
        <nav class="navbar">
            <a href="Logged.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
            <div class="nav-links" id="navLinks">
            <ul>
                <li class="navButton"><a href="Logged.php">Home</a></li>
                <li class="navButton"><a href="TopPageLogged.php">Top</a></li>
                <li class="navButton"><a href="ArtistsPage.php">Artists</a></li>
                <li class="navButton"><a href="LogoutSession.php">Log out</a></li>
                <li><a href="AccountInfo.php"><img  class="Account" src="Images/pfp.png" alt="Profile_Picture"></a></li>
                
            </ul>
        </div>
        </nav>
        <div class="HeaderLow">
            <div class="scroll-container">
                <!-- Containers repeated to create an infinite scroll effect -->
                <div class="container1">
                    <img src="Images/bladee.jpg" alt="bladee">
                    <p>bladee</p>
                    <p>KING NOTHINGG</p>
                    <a href="https://www.youtube.com/watch?v=-5SkU7ALjwQ&ab_channel=draingang" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/yunglean.jpg" alt="yung lean">
                    <p>Yung Lean</p>
                    <p>Things happen</p>
                    <a href="https://www.youtube.com/watch?v=an_gnfu2Sfw&ab_channel=YungLean" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/2hollis.jpg" alt="2hollis">
                    <p>2hollis</p>
                    <p>gold</p>
                    <a href="https://www.youtube.com/watch?v=3X2TE2tjIf8&ab_channel=2hollis" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/ghost.jpg" alt="Ghost Mountain">
                    <p>Ghost Mountain</p>
                    <p>APOLLON</p>
                    <a href="https://www.youtube.com/watch?v=k4uSU_JJQR8&ab_channel=GHOSTMOUNTAIN" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/joeyy.jpg" alt="Joeyy">
                    <p>Joeyy</p>
                    <p>Fiat</p>
                    <a href="https://www.youtube.com/watch?v=xCrO8m1auG8&ab_channel=joeyy-Topic" target="_blank"><button class="btn">View song</button></a>
                </div>
                <!-- Duplicate containers for seamless looping -->
                <div class="container1">
                    <img src="Images/bladee.jpg" alt="bladee">
                    <p>bladee</p>
                    <p>KING NOTHINGG</p>
                    <a href="https://www.youtube.com/watch?v=-5SkU7ALjwQ&ab_channel=draingang" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/yunglean.jpg" alt="yung lean">
                    <p>Yung Lean</p>
                    <p>Things happen</p>
                    <a href="https://www.youtube.com/watch?v=an_gnfu2Sfw&ab_channel=YungLean" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/2hollis.jpg" alt="2hollis">
                    <p>2hollis</p>
                    <p>gold</p>
                    <a href="https://www.youtube.com/watch?v=3X2TE2tjIf8&ab_channel=2hollis" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/ghost.jpg" alt="Ghost Mountain">
                    <p>Ghost Mountain</p>
                    <p>APOLLON</p>
                    <a href="https://www.youtube.com/watch?v=k4uSU_JJQR8&ab_channel=GHOSTMOUNTAIN" target="_blank"><button class="btn">View song</button></a>
                </div>
                <div class="container1">
                    <img src="Images/joeyy.jpg" alt="Joeyy">
                    <p>Joeyy</p>
                    <p>Fiat</p>
                    <a href="https://www.youtube.com/watch?v=xCrO8m1auG8&ab_channel=joeyy-Topic" target="_blank"><button class="btn">View song</button></a>
                </div>
            </div>  
        </div>
        <br>
    </section>
<hr>
<section class="Footer">
    <div class="FooterContent">
        <div class="FooterLinks">
            <ul>
            <li><a href="Logged.php">About Us</a></li>
                    <li><a href="contactLogged.php">Contact Us</a></li>
                    <li><a href="policyLogged.php">Privacy Policy</a></li>
                    <li><a href="TOSlogged.php">Terms of Service</a></li>
            </ul>
        </div>
        <div class="FooterSocials">
            <ul>
                <li><a href=""><img src="Images/facebook.png" alt=""></a></li>
                <li><a href=""><img src="Images/twitter.png" alt=""></a></li>
                <li><a href=""><img src="Images/instagram.png" alt=""></a></li>
            </ul>
        </div>
    </div>
    <h1>Copyright © 2024 ArloMusic All rights reserved.</h1>
</section>
<script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>